#include <windows.h>
#include <MercLib210.h>

/* The two macros below are used as error return codes */
/* in case the DLL does not load, or is missing one or */
/* more functions, respectively.  You must define them */
/* to whatever values are meaningful for your DLL.     */
#define kFailedToLoadDLLError     ???
#define kCouldNotFindFunction     ???

static HINSTANCE DLLHandle;

/* Declare the variables that hold the addresses of the function   */
/* pointers.                                                       */
static int (__stdcall *MCRS_open_Ptr)(BYTE PortNumber, int baudrate);
static int (__stdcall *MCRS_close_Ptr)(void);
static int (__stdcall *MCRS_setBuffer_Ptr)(void);
static WORD (__stdcall *MCRS_EOF_Ptr)(void);
static int (__stdcall *MCRS_clear_input_Ptr)(void);
static int (__stdcall *MCRS_sendChar_Ptr)(char *character);
static int (__stdcall *MCRS_sendString_Ptr)(char *command_string);
static int (__stdcall *MCRS_moveA_Ptr)(int axis, int position);
static int (__stdcall *MCRS_moveR_Ptr)(int axis, int shift);
static int (__stdcall *MCRS_getChar_Ptr)(char *character);
static int (__stdcall *MCRS_getString_Ptr)(char *report, WORD count);
static int (__stdcall *MCRS_getStringCR_Ptr)(char *report);
static int (__stdcall *MCRS_getMacro_Ptr)(int macno, char *report);
static int (__stdcall *MCRS_getPos_Ptr)(void);
static int (__stdcall *MCRS_getPosErr_Ptr)(void);
static int (__stdcall *MCRS_getVal_Ptr)(int query);
static int (__stdcall *MCRS_getQuery_Ptr)(char *command, char *report);
static int (__stdcall *MCRS_moving_Ptr)(void);
static int (__stdcall *MCRS_waitStop_Ptr)(void);
static int (__stdcall *MCRS_getSTB_Ptr)(int bytenumber);
static int (__stdcall *MCRS_getDLLversion_Ptr)(void);
static int (__stdcall *MCRS_initNetwork_Ptr)(int maxAxis);
static int (__stdcall *MCRS_select_Ptr)(int newAxis);
static int (__stdcall *MCRS_set_device_Ptr)(int newAxis);


/* Load the DLL and get the addresses of the functions */
static int LoadDLLIfNeeded(void)
{
    if (DLLHandle)
        return 0;

    DLLHandle = LoadLibrary("MercLib210.dll");
    if (DLLHandle == NULL) {
        return kFailedToLoadDLLError;
        }

    if (!(MCRS_open_Ptr = (void*) GetProcAddress(DLLHandle, "MCRS_open")))
        goto FunctionNotFoundError;

    if (!(MCRS_close_Ptr = (void*) GetProcAddress(DLLHandle, "MCRS_close")))
        goto FunctionNotFoundError;

    if (!(MCRS_setBuffer_Ptr = (void*) GetProcAddress(DLLHandle, 
         "MCRS_setBuffer")))
        goto FunctionNotFoundError;

    if (!(MCRS_EOF_Ptr = (void*) GetProcAddress(DLLHandle, "MCRS_EOF")))
        goto FunctionNotFoundError;

    if (!(MCRS_clear_input_Ptr = (void*) GetProcAddress(DLLHandle, 
         "MCRS_clear_input")))
        goto FunctionNotFoundError;

    if (!(MCRS_sendChar_Ptr = (void*) GetProcAddress(DLLHandle, "MCRS_sendChar")))
        goto FunctionNotFoundError;

    if (!(MCRS_sendString_Ptr = (void*) GetProcAddress(DLLHandle, 
         "MCRS_sendString")))
        goto FunctionNotFoundError;

    if (!(MCRS_moveA_Ptr = (void*) GetProcAddress(DLLHandle, "MCRS_moveA")))
        goto FunctionNotFoundError;

    if (!(MCRS_moveR_Ptr = (void*) GetProcAddress(DLLHandle, "MCRS_moveR")))
        goto FunctionNotFoundError;

    if (!(MCRS_getChar_Ptr = (void*) GetProcAddress(DLLHandle, "MCRS_getChar")))
        goto FunctionNotFoundError;

    if (!(MCRS_getString_Ptr = (void*) GetProcAddress(DLLHandle, 
         "MCRS_getString")))
        goto FunctionNotFoundError;

    if (!(MCRS_getStringCR_Ptr = (void*) GetProcAddress(DLLHandle, 
         "MCRS_getStringCR")))
        goto FunctionNotFoundError;

    if (!(MCRS_getMacro_Ptr = (void*) GetProcAddress(DLLHandle, "MCRS_getMacro")))
        goto FunctionNotFoundError;

    if (!(MCRS_getPos_Ptr = (void*) GetProcAddress(DLLHandle, "MCRS_getPos")))
        goto FunctionNotFoundError;

    if (!(MCRS_getPosErr_Ptr = (void*) GetProcAddress(DLLHandle, 
         "MCRS_getPosErr")))
        goto FunctionNotFoundError;

    if (!(MCRS_getVal_Ptr = (void*) GetProcAddress(DLLHandle, "MCRS_getVal")))
        goto FunctionNotFoundError;

    if (!(MCRS_getQuery_Ptr = (void*) GetProcAddress(DLLHandle, "MCRS_getQuery")))
        goto FunctionNotFoundError;

    if (!(MCRS_moving_Ptr = (void*) GetProcAddress(DLLHandle, "MCRS_moving")))
        goto FunctionNotFoundError;

    if (!(MCRS_waitStop_Ptr = (void*) GetProcAddress(DLLHandle, "MCRS_waitStop")))
        goto FunctionNotFoundError;

    if (!(MCRS_getSTB_Ptr = (void*) GetProcAddress(DLLHandle, "MCRS_getSTB")))
        goto FunctionNotFoundError;

    if (!(MCRS_getDLLversion_Ptr = (void*) GetProcAddress(DLLHandle, 
         "MCRS_getDLLversion")))
        goto FunctionNotFoundError;

    if (!(MCRS_initNetwork_Ptr = (void*) GetProcAddress(DLLHandle, 
         "MCRS_initNetwork")))
        goto FunctionNotFoundError;

    if (!(MCRS_select_Ptr = (void*) GetProcAddress(DLLHandle, "MCRS_select")))
        goto FunctionNotFoundError;

    if (!(MCRS_set_device_Ptr = (void*) GetProcAddress(DLLHandle, 
         "MCRS_set_device")))
        goto FunctionNotFoundError;

    return 0;

FunctionNotFoundError:
    FreeLibrary(DLLHandle);
    DLLHandle = 0;
    return kCouldNotFindFunction;
}


/* Glue Code for each of the DLL functions */



int __stdcall MCRS_open(BYTE PortNumber, int baudrate)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_open_Ptr)(PortNumber, baudrate);
}


int __stdcall MCRS_close(void)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_close_Ptr)();
}


int __stdcall MCRS_setBuffer(void)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_setBuffer_Ptr)();
}


WORD __stdcall MCRS_EOF(void)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_EOF_Ptr)();
}


int __stdcall MCRS_clear_input(void)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_clear_input_Ptr)();
}


int __stdcall MCRS_sendChar(char *character)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_sendChar_Ptr)(character);
}


int __stdcall MCRS_sendString(char *command_string)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_sendString_Ptr)(command_string);
}


int __stdcall MCRS_moveA(int axis, int position)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_moveA_Ptr)(axis, position);
}


int __stdcall MCRS_moveR(int axis, int shift)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_moveR_Ptr)(axis, shift);
}


int __stdcall MCRS_getChar(char *character)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_getChar_Ptr)(character);
}


int __stdcall MCRS_getString(char *report, WORD count)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_getString_Ptr)(report, count);
}


int __stdcall MCRS_getStringCR(char *report)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_getStringCR_Ptr)(report);
}


int __stdcall MCRS_getMacro(int macno, char *report)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_getMacro_Ptr)(macno, report);
}


int __stdcall MCRS_getPos(void)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_getPos_Ptr)();
}


int __stdcall MCRS_getPosErr(void)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_getPosErr_Ptr)();
}


int __stdcall MCRS_getVal(int query)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_getVal_Ptr)(query);
}


int __stdcall MCRS_getQuery(char *command, char *report)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_getQuery_Ptr)(command, report);
}


int __stdcall MCRS_moving(void)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_moving_Ptr)();
}


int __stdcall MCRS_waitStop(void)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_waitStop_Ptr)();
}


int __stdcall MCRS_getSTB(int bytenumber)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_getSTB_Ptr)(bytenumber);
}


int __stdcall MCRS_getDLLversion(void)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_getDLLversion_Ptr)();
}


int __stdcall MCRS_initNetwork(int maxAxis)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_initNetwork_Ptr)(maxAxis);
}


int __stdcall MCRS_select(int newAxis)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_select_Ptr)(newAxis);
}


int __stdcall MCRS_set_device(int newAxis)
{
    int dllLoadError;

    if (dllLoadError = LoadDLLIfNeeded())
        return dllLoadError;
    return (*MCRS_set_device_Ptr)(newAxis);
}

