//******************************************************************************
// File name : MercLib210_def.PAS
// IDE       : Delphi32  
// Purpose   : Type declarations for Mercury DLL
//
// Date      : 2001-12-02
//******************************************************************************

const
   ExtLib = 'MercLib210.DLL';

   LF = #10;
   CR = #13;

   // Error Base Codes
   EBC_init         = 16;
   EBC_setBuffer    = 32;
   EBC_EOF          = 48;
   EBC_getChar      = 64;
   EBC_getstring    = 80;
   EBC_sendChar     = 96;
   EBC_sendstring  = 112;
   EBC_sendstringE = 128;

   // Error codes
   ERR_readfile =     1;
   ERR_writefile =    2;
   ERR_timeout =      3;
   ERR_length =       4;
   ERR_content =      5;
   ERR_GetCommState = 6;
   ERR_SetCommState = 7;
   ERR_PurgeComm =    8;
   ERR_PortNumber =   9;
   ERR_handle =      10;

//------------------------------------------------------------------------------
//  Function Declarations  :
//------------------------------------------------------------------------------
// Case sensitive writing required !!

function MCRS_open(portnumber:byte; baudrate:integer):integer;
         stdcall external ExtLib; 
         
function MCRS_close:longint;
         stdcall external ExtLib; // 
         
function MCRS_setBuffer:integer;
         stdcall external ExtLib; // 

function MCRS_sendString(pCmd:pChar):integer;
         stdcall external ExtLib; // 

function MCRS_getPos:integer;
         stdcall external ExtLib; // 

function MCRS_getPosErr:integer;
         stdcall external ExtLib; // 

function MCRS_getVal(query:integer):integer;
         stdcall external ExtLib; // 

function MCRS_getQuery(pCmd,psRead:PChar):integer;
         stdcall external ExtLib; // 

function MCRS_getStringCR(psRead:PChar):integer;
         stdcall external ExtLib; // 

function MCRS_moving:integer;
         stdcall external ExtLib; // 

function MCRS_initNetwork(maxAxis:integer):integer;
         stdcall external ExtLib; // 

function MCRS_select(newaxis:integer):integer;
         stdcall external ExtLib; // 
         
function MCRS_set_device(newaxis:integer):integer;
         stdcall external ExtLib; // 
         
function MCRS_clear_input:integer;
         stdcall external ExtLib; // 

function MCRS_EOF:integer;
         stdcall external ExtLib; // 

function MCRS_getSTB(byteno:integer):integer;
         stdcall external ExtLib; // 
         
function MCRS_waitStop:integer;
         stdcall external ExtLib; // 

function MCRS_getDLLversion:integer;
         stdcall external ExtLib; //  index 60
         
function MCRS_moveA(axis,position:integer):integer;
         stdcall external ExtLib; //  index 32
         
function MCRS_moveR(axis,shift:integer):integer;
         stdcall external ExtLib; //  index 34
         
function MCRS_getMacro(macno:integer;content:PChar):integer;
         stdcall external ExtLib; //  index 36
         
//------------------------------------------------------------------------------
// End of file


